﻿<%@ Control Language="vb" AutoEventWireup="false" CodeBehind="SoldStationTransform.ascx.vb" Inherits="Web.SoldStationTransform" %>
<%@ Register Src="~/private/stations/base/Sections/ControlMode.ascx" TagName="cu_controlmode" TagPrefix="uc" %>

<asp:UpdatePanel ID="UpdatePanelImportStation" runat="server" UpdateMode="Conditional">
<ContentTemplate>

<div class="mode-panel">
   <div class="holder">
       <uc:cu_controlmode ID="cu_controlmode" runat="server" visible="false" />
   </div>
    <div class="holder" id="divBotones" runat="server" visible="true">
        <br />
        <asp:LinkButton ID="btnguardar" CssClass="guardar" runat="server" OnClick="btnguardar_Click"><%= CurrentContext.Translator.Translate("CONVERT_LNK_SAVE")%></asp:LinkButton> 
        <asp:LinkButton ID="btneliminar" runat="server" CssClass="eliminar" OnClick="btneliminar_Click" ></asp:LinkButton> 
        <asp:LinkButton ID="btncopiar" runat="server" CssClass="copiar" OnClick="btncopiar_Click" ></asp:LinkButton> 
   </div>
</div>
<br />
<div class="parameters-block">

    <asp:Panel ID="PanelConfiguraciones" runat="server" Visible="true">

        <div class="gridview">
            <asp:GridView ID="GridViewLlistat" SkinId="GridviewSkinLlistat" runat="server" DataKeyNames="PK_IDCONFIGURACIONESTACION" UseAccessibleHeader="false" ShowHeader="false" PageSize="20"> 
            <EmptyDataTemplate>
                    <asp:Label ID="lblNoHiHaElements" runat="server"  Text='<%# CurrentContext.Translator.Translate("MSG_ADMIN_NOELEMENTS")%>'></asp:Label>
            </EmptyDataTemplate>
            <Columns>
                <asp:TemplateField ItemStyle-CssClass="CampRowList" ItemStyle-Width="35"  >
				    <ItemTemplate>
                        <span class='<%# Eval("CssConfig")%>' runat="server" ID="imageConfig"></span>
                    </ItemTemplate>
				    </asp:TemplateField>
                <asp:TemplateField ItemStyle-CssClass="CampRowList">
				    <ItemTemplate>
					    <asp:Label CssClass = "CampDades"  ID="lblrowFieldGridEmail" runat="server" ToolTip='<%# Bind("Etiqueta")%>' Text='<%# Bind("Etiqueta") %>'></asp:Label>
				    </ItemTemplate>
				    </asp:TemplateField>
                <asp:TemplateField ItemStyle-CssClass="CampRowList" ItemStyle-Width="35">
                    <ItemTemplate>
                        <asp:LinkButton ID="btncargar2" CssClass="cargar" runat="server" CommandName="CARGARCONFIGURACION" CommandArgument='<%#Eval("PK_IDCONFIGURACIONESTACION")%>'  Visible='<%# StationPage.GetControlModeEstacion()%>'></asp:LinkButton>
				    </ItemTemplate>
				    </asp:TemplateField>
                <asp:ButtonField Text="DobleClick" CommandName="DobleClick" Visible="False" />
            </Columns>
            </asp:GridView>
            <asp:HiddenField ID="hdnGridViewLlistat_SelectedIndexClient" runat="server" Value="-1" />    
        </div>
    </asp:Panel>

    <asp:Panel ID="ProcessPanel" runat="server" Visible="false">
        <div class="parameters-block">
            <ul class="parameters-list jcf-scrollable">
            <asp:ListView ID="lstViewLogs" runat="server" >  
               <ItemTemplate>
                   <li style="height:50px !important; position:relative; padding-left:10px; background-color:#eaeaea;">
                       <span style="margin-top:15px !important; position:relative; float:left; "><b><%# CurrentContext.Translator.Translate(Eval("Message"))%>&nbsp;</b><%#Eval("Value")%></span>
                       <span style="margin-top:15px !important; position:relative; float:left;"><%#Eval("Process")%></span>
                       <asp:LinkButton runat="server" CssClass='<%#If(Eval("Action") = 0, "log_igual", If(Eval("Action") = 1, "log_ok", If(Eval("Action") = 2, "log_ko", "no_log"))) %>'></asp:LinkButton>
                   </li>
               </ItemTemplate>
                <EmptyDataTemplate>
                    <div>
                       <span><%= CurrentContext.Translator.Translate("MSG_ADMIN_NOELEMENTS")%></span>
                    </div>
                </EmptyDataTemplate>
            </asp:ListView>
            </ul>
        </div>
    </asp:Panel>
</div>

    <!--Panel de formulario de entrada de datos -->
    <asp:Panel ID="PanelEntradaDatos" runat="server" Style="display:none" CssClass="error-message">
        <div class="holder">
            <p><span><%= CurrentContext.Translator.Translate("CONVERT_LITERAL")%></span></p>
            <asp:LinkButton ID="btnAceptar_PanelEntradaDatos" runat="server" CssClass="btn"  OnClick="btnAceptar_PanelEntradaDatos_Click" ><%= CurrentContext.Translator.Translate("CONVERT_OK")%></asp:LinkButton>
            <a id="btnCancelar_PanelEntradaDatos" href="#"  runat="server" class="btn"><%= CurrentContext.Translator.Translate("CONVERT_CANCEL")%></a>
        </div>
    </asp:Panel>

    <!--Panel de formulario de guardar configuración -->
    <asp:Panel ID="PanelGuardarConfiguracion" runat="server" Style="display:none" CssClass="error-message">
        <div class="reg-form">
            <fieldset class="holder">
                <div class="row">
                    <span class="label" style="color:white;"><%= CurrentContext.Translator.Translate("CONVERT_SAVE")%></span>
                    <asp:TextBox ID="Etiqueta" runat="server" MaxLength="200" ></asp:TextBox>
                </div>
                <div class="row">
                    <span class="label" style="color:white;width:100px"><%= CurrentContext.Translator.Translate("CONVERT_PUBLIC")%></span>
                    <span class="label" style="color:white;width:100px"><%= CurrentContext.Translator.Translate("CONVERT_PUBLIC")%></span>
                    <asp:DropDownList ID="Publica" runat="server" CssClass="input">
                    </asp:DropDownList>
                </div>
                <div class="row">
                    <asp:LinkButton ID="btnAceptar_PanelGuardarConfiguracion" runat="server" CssClass="btn"  OnClick="btnAceptar_PanelGuardarConfiguracion_Click" ><%= CurrentContext.Translator.Translate("CONVERT_OK")%></asp:LinkButton>
                    <a id="btnCancelar_PanelGuardarConfiguracion" href="#"  runat="server" class="btn"><%= CurrentContext.Translator.Translate("CONVERT_CANCEL")%></a>
                </div>
            </fieldset>
        </div>
            
    </asp:Panel>

    <!--Panel de formulario de borrar una configuración -->
    <asp:Panel ID="PanelBorrarConfiguracion" runat="server" Style="display:none" CssClass="error-message">
        <div class="holder">
            <p><%= CurrentContext.Translator.Translate("CONVERT_DELETE")%></p>
            <asp:LinkButton ID="btnAceptar_BorrarConfiguracion" runat="server" CssClass="btn"  OnClick="btnAceptar_BorrarConfiguracion_Click" ><%= CurrentContext.Translator.Translate("CONVERT_OK")%></asp:LinkButton>
            <a id="btnCancelar_BorrarConfiguracion" href="#"  runat="server" class="btn"><%= CurrentContext.Translator.Translate("CONVERT_CANCEL")%></a>
        </div>
    </asp:Panel>

    <!--Panel de formulario de copiar una configuración -->
    <asp:Panel ID="PanelCopiarConfiguracion" runat="server" Style="display:none" CssClass="error-message">
        <div class="reg-form">
            <fieldset class="holder">
                <div class="row">
                    <span class="label" style="color:white;"><%= CurrentContext.Translator.Translate("CONVERT_COPY")%></span>
                    <asp:TextBox ID="EtiquetaCopia" runat="server" MaxLength="200" ></asp:TextBox>
                </div>                                        
                <div class="row">
                    <span class="label"  style="color:white;width:100px"><%= CurrentContext.Translator.Translate("CONVERT_PUBLIC")%></span>
                    <asp:DropDownList ID="PublicaCopia" runat="server" CssClass="input">
                    </asp:DropDownList>
                </div>
                <div class="row">
                    <asp:LinkButton ID="btnAceptar_CopiarConfiguracion" runat="server" CssClass="btn"  OnClick="btnAceptar_CopiarConfiguracion_Click" ><%= CurrentContext.Translator.Translate("CONVERT_CFGCOPY")%></asp:LinkButton>
                    <a id="btnCancelar_CopiarConfiguracion" href="#"  runat="server" class="btn"><%= CurrentContext.Translator.Translate("CONVERT_CANCEL")%></a>
                </div>
            </fieldset>
        </div>
    </asp:Panel>

    <!--Panel de errores del formulario de login -->
    <asp:Panel ID="PanelErrores" runat="server" Style="display:none" CssClass="error-message">
        <div class="holder">
            <asp:Literal ID="infoerrores" runat="server"></asp:Literal>
            <a id="btnCancelar_PanelErrores" href="#" runat="server" class="btn">Ok</a>
	    </div>
    </asp:Panel>

    <!-- controles ocultos-->
    <asp:HiddenField ID="hdnIdConfiguracionEstacion" runat="server" />
    <asp:HiddenField ID="hdnPanelEntradaDatos" runat="server" />
    <asp:HiddenField ID="hdnPanelGuardarConfiguracion" runat="server" />
    <asp:HiddenField ID="hdnPanelBorrarConfiguracion" runat="server" />
    <asp:HiddenField ID="hdnPanelCopiarConfiguracion" runat="server" />
    <asp:HiddenField ID="hdnPanelErrores" runat="server" />

    <!-- controles ajax-->
    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelEntradaDatos" runat="server" TargetControlID="hdnPanelEntradaDatos" PopupControlID="PanelEntradaDatos" BackgroundCssClass="" CancelControlID="btnCancelar_PanelEntradaDatos" DropShadow="false" PopupDragHandleControlID="" X="0"/>
    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelGuardarConfiguracion" runat="server" TargetControlID="hdnPanelGuardarConfiguracion" PopupControlID="PanelGuardarConfiguracion" BackgroundCssClass="" CancelControlID="btnCancelar_PanelGuardarConfiguracion" DropShadow="false" PopupDragHandleControlID="" X="0"/>
    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelBorrarConfiguracion" runat="server" TargetControlID="hdnPanelBorrarConfiguracion" PopupControlID="PanelBorrarConfiguracion" BackgroundCssClass="" CancelControlID="btnCancelar_BorrarConfiguracion" DropShadow="false" PopupDragHandleControlID="" X="0"/>
    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelCopiarConfiguracion" runat="server" TargetControlID="hdnPanelCopiarConfiguracion" PopupControlID="PanelCopiarConfiguracion" BackgroundCssClass="" CancelControlID="btnCancelar_CopiarConfiguracion" DropShadow="false" PopupDragHandleControlID="" X="0"/>    
    <ajaxToolkit:ModalPopupExtender ID="MPE_PanelErrores" runat="server" TargetControlID="hdnPanelErrores" PopupControlID="PanelErrores" BackgroundCssClass="" CancelControlID="btnCancelar_PanelErrores" DropShadow="false" PopupDragHandleControlID=""/>

</ContentTemplate>
</asp:UpdatePanel> 


<ajaxToolkit:UpdatePanelAnimationExtender ID="UpdatePanelAnimationExtenderImportStation" TargetControlID="UpdatePanelImportStation" BehaviorID="animation" runat="server">    
<Animations>
    <OnUpdating>
        <Sequence>
            <ScriptAction Script="LockScreen();" />
        </Sequence>
    </OnUpdating>
    <OnUpdated>
        <Sequence>
            <ScriptAction Script="UnlockScreen(); initRefreshFunctions2($('div.ajax-holder'));"  />
        </Sequence>
    </OnUpdated>
</Animations>
</ajaxToolkit:UpdatePanelAnimationExtender>

<asp:UpdateProgress ID="UpdateProgressImportStation" runat="server" AssociatedUpdatePanelID="UpdatePanelImportStation" DisplayAfter="100">
    <ProgressTemplate>
        <asp:Image ID="img_ajax_loading_MenuStation" runat="server" ImageUrl="~/images/ajax-loading.gif" CssClass="ajax_loading_centered" Style="z-index: 100002;" />
    </ProgressTemplate>
</asp:UpdateProgress>

